/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.string;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.DynamicValueInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.items.StringCustomizationItem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class LayoutString
extends LayoutElement {
    protected AdvancedButton alignmentLeftBtn;
    protected AdvancedButton alignmentRightBtn;
    protected AdvancedButton alignmentCenteredBtn;

    public LayoutString(StringCustomizationItem parent, LayoutEditorScreen handler) {
        super(parent, true, handler);
        this.setScale(this.getStringScale());
    }

    @Override
    public void init() {
        super.init();
        AdvancedButton scaleB = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setscale", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setscale", (String[])new String[0]) + ":", CharacterFilter.getDoubleCharacterFiler(), 240, this::setScaleCallback)));
        this.rightclickMenu.addContent(scaleB);
        String sLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setshadow", (String[])new String[0]);
        if (this.getObject().shadow) {
            sLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setnoshadow", (String[])new String[0]);
        }
        AdvancedButton shadowB = new AdvancedButton(0, 0, 0, 16, sLabel, true, press -> {
            if (this.getObject().shadow) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = false;
            } else {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setnoshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = true;
            }
        });
        this.rightclickMenu.addContent(shadowB);
        AdvancedButton textColorButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color", (String[])new String[0]), press -> {
            FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    if (!call.equals(this.getObject().textColorHex)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    this.getObject().textColorHex = call;
                    this.getObject().textColor = RenderUtils.getColorFromHexString((String)call);
                }
            });
            if (this.getObject().textColorHex != null) {
                pop.setText(this.getObject().textColorHex);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        textColorButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color.btn.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(textColorButton);
        AdvancedButton editTextB = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.edit", (String[])new String[0]), true, press -> {
            DynamicValueInputPopup i = new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.edit", (String[])new String[0]) + ":", null, 240, this::setTextCallback);
            i.setText(StringUtils.convertFormatCodes((String)this.object.value, (String)"\u00a7", (String)"&"));
            PopupHandler.displayPopup((Popup)i);
        });
        editTextB.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.onlybasicchars", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(editTextB);
        this.rightclickMenu.addSeparator();
    }

    @Override
    protected void renderBorder(MatrixStack matrix, int mouseX, int mouseY) {
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.width), (int)(this.getStringPosY() + 1), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)(this.getStringPosY() + this.object.height), (int)(this.getStringPosX() + this.object.width + 1), (int)(this.getStringPosY() + this.object.height + 1), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + 1), (int)(this.getStringPosY() + this.object.height), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)(this.getStringPosX() + this.object.width), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.width + 1), (int)(this.getStringPosY() + this.object.height), (int)Color.BLUE.getRGB());
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderUtils.setScale((MatrixStack)matrix, (float)0.5f);
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.orientation", (String[])new String[0]) + ": " + this.object.orientation, (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 44), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.border.scale", (String[])new String[0]) + ": " + this.getStringScale(), (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 35), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.border.alignment", (String[])new String[0]) + ": " + this.getObject().alignment.key, (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 26), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.posx", (String[])new String[0]) + ": " + this.getStringPosX(), (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 17), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.width", (String[])new String[0]) + ": " + this.object.width, (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 8), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.posy", (String[])new String[0]) + ": " + this.getStringPosY(), (float)((this.getStringPosX() + this.object.width) * 2 + 3), (float)((this.getStringPosY() + this.object.height) * 2 - 14), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.height", (String[])new String[0]) + ": " + this.object.height, (float)((this.getStringPosX() + this.object.width) * 2 + 3), (float)((this.getStringPosY() + this.object.height) * 2 - 5), Color.WHITE.getRGB());
        RenderUtils.postScale((MatrixStack)matrix);
    }

    private int getStringPosX() {
        return this.object.getPosX();
    }

    private int getStringPosY() {
        return this.object.getPosY();
    }

    private float getStringScale() {
        return ((StringCustomizationItem)this.object).scale;
    }

    public StringCustomizationItem getObject() {
        return (StringCustomizationItem)this.object;
    }

    @Override
    public boolean isGrabberPressed() {
        return false;
    }

    @Override
    public int getActiveResizeGrabber() {
        return -1;
    }

    public void setScale(float scale) {
        if (this.getObject().scale != scale) {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        }
        ((StringCustomizationItem)this.object).scale = scale;
    }

    public void setText(String text) {
        if (!this.getObject().valueRaw.equals(text)) {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        }
        this.getObject().valueRaw = text;
        this.getObject().value = text;
        this.setScale(this.getStringScale());
    }

    private void setTextCallback(String text) {
        if (text == null) {
            return;
        }
        if (text.length() > 0) {
            this.setText(StringUtils.convertFormatCodes((String)text, (String)"&", (String)"\u00a7"));
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.desc", (String[])new String[0]), "", "", "", "");
        }
    }

    private void setScaleCallback(String scale) {
        if (scale == null) {
            return;
        }
        if (MathUtils.isFloat((String)scale)) {
            this.setScale(Float.valueOf(scale).floatValue());
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.scale.invalidvalue.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.scale.invalidvalue.desc", (String[])new String[0]), "", "", "", "", "");
        }
    }

    @Override
    protected void updateHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.getStringPosX() && mouseX <= this.getStringPosX() + this.object.width && mouseY >= this.getStringPosY() && mouseY <= this.getStringPosY() + this.object.height;
    }

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        PropertiesSection p1 = new PropertiesSection("customization");
        p1.addEntry("action", "addtext");
        p1.addEntry("actionid", this.object.getActionId());
        if (this.object.delayAppearance) {
            p1.addEntry("delayappearance", "true");
            p1.addEntry("delayappearanceeverytime", "" + this.object.delayAppearanceEverytime);
            p1.addEntry("delayappearanceseconds", "" + this.object.delayAppearanceSec);
            if (this.object.fadeIn) {
                p1.addEntry("fadein", "true");
                p1.addEntry("fadeinspeed", "" + this.object.fadeInSpeed);
            }
        }
        p1.addEntry("value", this.object.value);
        p1.addEntry("x", "" + this.object.posX);
        p1.addEntry("y", "" + this.object.posY);
        p1.addEntry("orientation", this.object.orientation);
        p1.addEntry("scale", "" + this.getObject().scale);
        p1.addEntry("shadow", "" + this.getObject().shadow);
        p1.addEntry("alignment", "" + this.getObject().alignment.key);
        p1.addEntry("textcolor", this.getObject().textColorHex);
        this.addVisibilityPropertiesTo(p1);
        l.add(p1);
        return l;
    }
}

